#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll x, h, idx;
} Jarbol;

int cmp(const void *a, const void *b){
    Jarbol *p1 = (Jarbol*)a;
    Jarbol *p2 = (Jarbol*)b;
    if(p1->x != p2->x) return p1->x < p2->x ? -1 : 1;
    return 0;
}

int main(){
    int n;
    scanf("%d",&n);
    Jarbol *arr = malloc(n*sizeof(Jarbol));
    for(int i=0;i<n;i++){ scanf("%lld",&arr[i].x); arr[i].idx=i; }
    for(int i=0;i<n;i++) scanf("%lld",&arr[i].h);

    
    qsort(arr,n,sizeof(Jarbol),cmp);

    ll *res = malloc(n*sizeof(ll));
    for(int i=0;i<n;i++) res[i] = -1;


    for(int i=0;i<n;i++){
        ll best = -1;


        if(i>0){
            ll x1 = arr[i-1].x, h1 = arr[i-1].h;
            ll x2 = arr[i].x, h2 = arr[i].h;
            ll dx = x2 - x1;
            ll dh = h2 - h1;
            ll x_peak = (x1 + x2 + h1 - h2)/2;
            ll h_peak = (h1 + h2 + dx)/2;
            ll d = -1;
            if(arr[i].h <= h2) d = arr[i].x - x2;
            if(arr[i].h <= h1) {
                ll d1 = arr[i].x - x1;
                if(d==-1 || llabs(d1)<llabs(d)) d=d1;
            }
            if(arr[i].h <= h_peak){
                ll d2 = arr[i].x - x_peak;
                if(d==-1 || llabs(d2)<llabs(d)) d=d2;
            }
            if(d!=-1) best = d;
        }

        
        if(i<n-1){
            ll x1 = arr[i].x, h1 = arr[i].h;
            ll x2 = arr[i+1].x, h2 = arr[i+1].h;
            ll dx = x2 - x1;
            ll dh = h2 - h1;
            ll x_peak = (x1 + x2 + h1 - h2)/2;
            ll h_peak = (h1 + h2 + dx)/2;
            ll d = -1;
            if(arr[i].h <= h2) d = x2 - arr[i].x;
            if(arr[i].h <= h1) {
                ll d1 = x1 - arr[i].x;
                if(d==-1 || llabs(d1)<llabs(d)) d=d1;
            }
            if(arr[i].h <= h_peak){
                ll d2 = x_peak - arr[i].x;
                if(d==-1 || llabs(d2)<llabs(d)) d=d2;
            }
            if(d!=-1){
                if(best==-1 || llabs(d)<llabs(best)) best=d;
            }
        }

        if(best!=-1) res[arr[i].idx]=llabs(best);
    }

    for(int i=0;i<n;i++){
        printf("%lld\n",res[i]);
    }

    free(arr); free(res);
    return 0;
}